using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Items;
using Server.Engines.Lua;
using RemoteScripting;
using LuaInterface;

namespace Server.Engines.XmlSpawner2
{
	class XmlLuaScript : XmlAttachment, ILuaCodeConsumer
	{
		private LuaInterface.Lua m_Lua;
		private LuaCode m_Code;
		private string m_Script;

		public LuaInterface.Lua Lua
		{
			get 
            {
                if (m_Lua == null)
                    m_Lua = new LuaInterface.Lua();
                return m_Lua; 
            }
		}

		public LuaCode Code
		{
			get { return m_Code; }
			set
			{
				if ( m_Code != null )
				{
					m_Code.Unsubscribe( this );
				}

				m_Code = value;

				if ( m_Code != null )
				{
					m_Code.Subscribe( this );
				}
			}
		}

		[CommandProperty( AccessLevel.GameMaster )]
		public string Script
		{
			get { return m_Script; }
			set
			{
				m_Script = value;

				Code = (LuaCode)LuaCodeBase.Scripts[m_Script];
			}
		}

		public string Description
		{
			get
			{
				if ( AttachedTo is Mobile )
				{
					Mobile mobile = AttachedTo as Mobile;

					return String.Format( "XmlLuaScript, Mobile '{0}', Type '{1}', Serial {2}", mobile.Name, mobile.GetType().ToString(), mobile.Serial.Value.ToString() );
				}
				else if ( AttachedTo is Item )
				{
					Item item = AttachedTo as Item;

					return String.Format( "XmlLuaScript, Item '{0}', Type '{1}', Serial {2}", item.Name, item.GetType().ToString(), item.Serial.Value.ToString() );
				}

				return "Some object";
			}
		}

		public void Update()
		{
			if ( m_Code != null )
			{
				m_Lua = new LuaInterface.Lua();

				try
				{
					m_Lua["owner"] = this;
					m_Lua["this"] = AttachedTo;

					m_Lua.DoString( m_Code.Code );

					LuaHelper.CallFunction( this, "OnInitialize" );
				}
				catch ( Exception e )
				{
					LuaHelper.BroudcastError( this, e.Message );
				}
			}
		}

		public void OnError( string message )
		{

		}

		public void OnLostSubscription()
		{
			Script = null;
			Update();
		}

		public void OnScriptChanged()
		{
			Update();
		}

		[Attachable]
		public XmlLuaScript()
		{
		}

		[CommandProperty( AccessLevel.GameMaster )]
		public override bool HandlesOnSpeech { get { return true; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public override bool HandlesOnMovement { get { return true; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public override bool HandlesOnKill { get { return true; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public override bool HandlesOnKilled { get { return true; } }

		public override void OnAttach()
		{
			base.OnAttach();

			ArrayList attachments = XmlAttach.FindAttachments( AttachedTo, typeof( XmlLuaScript ) );

			if ( ( AttachedTo is Mobile || AttachedTo is Item ) && attachments.Count == 1 )
			{
				m_Lua = new LuaInterface.Lua();

				try
				{
					m_Lua["this"] = AttachedTo;

				  LuaHelper.CallFunction( this, "OnAttach" );
				}
				catch ( Exception e )
				{
					LuaHelper.BroudcastError( this, e.Message );
				}
			}
			else
			{
				Delete();
			}
		}

		public override bool BlockDefaultOnUse( Mobile from, object target )
		{
			return LuaHelper.CallFunction( this, "BlockDefaultOnUse" ).AsBoolean( 0, false );
		}

		public override void OnUse( Mobile from )
		{
			LuaHelper.CallFunction( this, "OnUse", from );
		}

		public override void OnUser( object target )
		{
			LuaHelper.CallFunction( this, "OnUser", target );
		}

		public override void OnSpeech( SpeechEventArgs args )
		{
			LuaHelper.CallFunction( this, "OnSpeech", args );
		}

		public override void OnMovement( MovementEventArgs args )
		{
			LuaHelper.CallFunction( this, "OnMovement", args );
		}

		public override void OnKill( Mobile killed, Mobile killer )
		{
			LuaHelper.CallFunction( this, "OnKill", killed, killer );
		}

		public override void OnBeforeKill( Mobile killed, Mobile killer )
		{
			LuaHelper.CallFunction( this, "OnBeforeKill", killed, killer );
		}

		public override void OnKilled( Mobile killed, Mobile killer )
		{
			LuaHelper.CallFunction( this, "OnKilled", killed, killer );
		}

		public override void OnBeforeKilled( Mobile killed, Mobile killer )
		{
			LuaHelper.CallFunction( this, "OnBeforeKilled", killed, killer );
		}

		public override void OnWeaponHit( Mobile attacker, Mobile defender, BaseWeapon weapon, int damageGiven )
		{
			LuaHelper.CallFunction( this, "OnWeaponHit", attacker, defender, weapon, damageGiven );
		}

		public override int OnArmorHit( Mobile attacker, Mobile defender, Item armor, BaseWeapon weapon, int damageGiven )
		{
			return LuaHelper.CallFunction( this, "OnArmorHit", attacker, defender, armor, weapon, damageGiven ).AsInteger( 0, 0 );
		}

		public override string OnIdentify( Mobile from )
		{
			return LuaHelper.CallFunction( this, "OnIdentify", from ).AsString( 0, null );
		}

		public XmlLuaScript( ASerial serial )
			: base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int)1 );

			writer.Write( (string)m_Script );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 1:
					{
						Script = reader.ReadString();

						break;
					}
			}
		}
	}
}
